/*
 * $QNXLicenseC:
 * Copyright 2010, QNX Software Systems. All Rights Reserved.
 *
 * You must obtain a written license from and pay applicable
 * license fees to QNX Software Systems before you may reproduce,
 * modify or distribute this software, or any work that includes
 * all or part of this software.   Free development licenses are
 * available for evaluation and non-commercial purposes.  For more
 * information visit http://licensing.qnx.com or email
 * licensing@qnx.com.
 *
 * This file may contain contributions from others.  Please review
 * this entire file for other proprietary rights or license notices,
 * as well as the QNX Development Suite License Guide at
 * http://licensing.qnx.com/license-guide/ for other information.
 * $
 */

#ifndef UNITTEST
#include <sys/srcversion.h>
#endif

#ifndef PLATFORM_H_
#define PLATFORM_H_

struct cypress_dev;

typedef struct {
    int (*tp_init)(struct cypress_dev* dev);
    int (*tp_reset)(struct cypress_dev* dev);
    int (*tp_clear_irq)(struct cypress_dev* dev);
    void (*tp_fini)(struct cypress_dev* dev);
    void* data;
} platform_specific_t;

int cypress_platform_init(struct cypress_dev* dev);
void cypress_platform_fini(struct cypress_dev* dev);

int cypress_platform_tp_init(struct cypress_dev* dev);
int cypress_platform_tp_msg_pending(struct cypress_dev* dev);
int cypress_platform_tp_reset(struct cypress_dev* dev);
void cypress_platform_tp_fini(struct cypress_dev* dev);

#endif /* PLATFORM_H_ */

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn.ott.qnx.com/product/branches/7.0.0/trunk/hardware/mtouch/cypress/platform.h $ $Rev: 886397 $")
#endif
